import { world, Player, system } from "@minecraft/server";
import { ActionFormData, ModalFormData, MessageFormData } from "@minecraft/server-ui";

function getScore(objective, target, useZero = false) {
  try {
    const oB = world.scoreboard.getObjective(objective);
    if (typeof target === 'string') return oB.getScore(oB.getParticipants().find(pT => pT.displayName === target));
    return oB.getScore(target.scoreboardIdentity);
  } catch {
    return useZero ? 0 : NaN;
  }
}

let currentColorIndex = 0;
const colorCodes = ["§c", "§6", "§e", "§a", "§b", "§d"];
const casinoText = "CASINO"; 
const bottomText = "§7Click To Play";
const enter = "\n";

system.runInterval(() => {
  for (const entity of world.getDimension('minecraft:overworld').getEntities()) {
    if (entity.typeId === "ajay:casino") {
      let nameTag = "§l";
      for (let i = 0; i < casinoText.length; i++) {
        nameTag += colorCodes[(currentColorIndex + i) % colorCodes.length] + casinoText[i];
      }
      entity.nameTag = nameTag + enter + bottomText;
      currentColorIndex = (currentColorIndex + 1) % colorCodes.length;
    }
  }
}, 10);

world.afterEvents.entityHitEntity.subscribe(({ damagingEntity: player, hitEntity: target }) => {
  if (!(player instanceof Player)) return;
  if (target.typeId === "ajay:casino") {
    warn(player);
  }
})

function warn(player) {
  const form = new MessageFormData()
    .title("Warning!")
    .body(`§cWARNING: This is a gambling game! §r\nIf you're not sure, exit now. §r\nWhen you choose to play, be responsible. §r\nYour decision, your risk. §r`)
    .button1(`Continue`)
    .button2(`Cancel`)
  form.show(player).then(result => {
    if (result.selection === 1) {
      player.runCommandAsync(`playsound note.pling @s`)
    }
    if (result.selection === 0) {
      casino(player);
    }
  });
}

function casino(player) {
  const form = new ActionFormData()
    .title("Casino Area")
    .body(` \n              §l§cCA§eSI§aNO §bGA§dMES\n\n§rHello §c${player.name}, \n\n§f§6Welcome §fto our gaming zone,\nTry your luck with §edice §for §aroulette,§r or just enjoy the show with a big smile. Don't forget, if you decide to §bskip §fthe game,§f well, that's an okay choice §dLol`)
    .button(`§r§lGuess the Number\n§r§oClick to play`, `textures/ui/tiny_agnes`)
    .button(`§r§lLucky Card Draw\n§r§oClick to play`, `textures/ui/village_hero_effect`)
    .button(`§r§lOpen the Door\n§r§oClick to play`, `textures/items/door_wood`)
    .button(`§r§lDice\n§r§oClick to play`, `textures/ui/icon_random`)
    .button(`§c§lClose\n§r§oClick to Close`, `textures/ui/redX1`)
  form.show(player).then(result => {
    if (result.selection === 0) {
      guessNumber(player);
    }
    if (result.selection === 1) {
      openLuckyCardDraw(player);
    }
    if (result.selection === 2) {
      openDoor(player);
    }
    if (result.selection === 3) {
      dice(player);
    }
  });
}

//=====GAMES=====GAMES=====GAMES=====GAMES=====GAMES=====GAMES=====GAMES=====GAMES=====GAMES=====GAMES=====GAMES=====GAMES=====GAMES=====GAMES====GAMES=====GAMES====\\

function dice(player) {
  const playerMoney = getScore("money", player.name);
  const form = new ModalFormData()
    .title("Dice")
    .dropdown(" \n              §l§cCA§eSI§aNO §bGA§dMES\n\n§r§eHow to Play:\n§rFirst, enter the bet amount and then guess whether the dice result is even or odd.\n\nMake your prediction\n§7* pilih prediksi mu", ["Odd", "Even"])
    .textField(`Enter the bet amount (min. 5k)`, "5000");
  form.show(player).then(result => {
    const predictionIndex = parseInt(result.formValues[0]); // Get the dropdown selection index
    const betAmount = parseInt(result.formValues[1]);
    let prediction = "";
    if (predictionIndex === 0) {
      prediction = "Odd";
    } else if (predictionIndex === 1) {
      prediction = "Even";
    } else {
      player.sendMessage("§l§cCA§eSI§aNO §bGA§dMES §r§8// §rPlease select a valid prediction.");
      return;
    }
    if (isNaN(betAmount) || betAmount < 5000) {
      player.sendMessage("§l§cCA§eSI§aNO §bGA§dMES §r§r§8 -§rPlease enter a minimum bet amount of 5k coins.");
      return;
    }
    if (betAmount > playerMoney) {
      player.sendMessage("§l§cCA§eSI§aNO §bGA§dMES §r§8// §rSorry, you don't have enough money for this bet.");
      return;
    }
    const diceResult = Math.floor(Math.random() * 6) + 1; // Dice roll result
    const isOdd = (diceResult % 2 !== 0);
    const winAmount = ((isOdd && prediction === "Odd") || (!isOdd && prediction === "Even")) ? betAmount : -betAmount;

    if (winAmount > 0) {
      player.runCommand(`scoreboard players add @s money ${winAmount}`);
      player.sendMessage(`§l§cCA§eSI§aNO §bGA§dMES §r§8- §rCongratulations! Dice result: ${diceResult}. Your prediction "${prediction}" is correct. You win ${winAmount} coins!`);
      player.runCommand(`playsound random.levelup @s`);
      player.runCommand(`execute at @s run summon fireworks_rocket ~~~`);
    } else {
      player.runCommand(`scoreboard players remove @s money ${-winAmount}`);
      player.sendMessage(`§l§cCA§eSI§aNO §bGA§dMES §r§r§8- §rSorry, dice result: ${diceResult}. Your prediction "${prediction}" is incorrect. You lose ${-winAmount} coins. Better luck next time.`);
      player.runCommand(`playsound mob.wither.death @s`);
    }
  });
}




let currentGuessNumberLevel = 1; // Initialize the level when starting
function guessNumber(player) {
  const form = new ModalFormData()
    .title("Guess the Number")
    .textField(" \n              §l§cCA§eSI§aNO §bGA§dMES\n\n§r§eHow to Play:\n§rEnter the bet amount (minimum 5k):\nthen try to guess the correct number\n\nEnter the bet amount\n§7* masukan jumlah taruhan", "5000");
  form.show(player).then(result => {
    const playerMoney = getScore("money", player.name);
    const betAmount = parseInt(result.formValues[0]);
    if (isNaN(betAmount) || betAmount < 5000 || betAmount > 500000) {
      player.sendMessage("§l§cCA§eSI§aNO §bGA§dMES §r§r§8 -§rPlease enter a minimum bet amount of 5k coins and a maximum of 500k.");
      return;
    }
    if (betAmount > playerMoney) {
      player.sendMessage("§l§cCA§eSI§aNO §bGA§dMES §r§8// §rSorry, you don't have enough money for this bet.");
      return;
    }

    // Select a random number for the player to guess
    const minNumber = Math.floor(Math.random() * 90) + 1;
    const maxNumber = minNumber + 10;
    const correctNumber = Math.floor(Math.random() * 10) + minNumber;

    // Display number options in a dropdown
    const dropdownOptions = [];
    for (let i = 0; i < 10; i++) {
      dropdownOptions.push(`${minNumber + i}`);
    }

    const numberRange = `${minNumber} - ${maxNumber}`;
    const numberForm = new ModalFormData()
      .title("Guess the Number")
      .dropdown(`Guess the number from ${numberRange}\n§7* Tebak angka dari ${numberRange}\n§r\nChoose a number`, dropdownOptions);
    numberForm.show(player).then(numberResult => {
      if (numberResult.canceled) return player.sendMessage(`§l§cCA§eSI§aNO §bGA§dMES §r§r§8 -§rGame Canceled!`) || player.runCommandAsync(`playsound note.pling @s`);
      const selectedNumber = parseInt(numberResult.formValues[0]) + minNumber;
      // Generate a random value between 0 and 1
      const randomValue = Math.random();

      if (randomValue <= 0.45) {
        // Player guessed the number correctly
        player.runCommand(`scoreboard players add @s money ${betAmount}`);
        player.sendMessage(`§l§cCA§eSI§aNO §bGA§dMES §r§r§8 -§rCongratulations! You guessed the number ${selectedNumber} correctly! You win ${betAmount} coins.`);
        player.runCommand(`playsound random.levelup @s`);
      } else {
        // Player guessed incorrectly
        player.runCommand(`scoreboard players remove @s money ${betAmount}`);
        player.sendMessage(`§l§cCA§eSI§aNO §bGA§dMES §r§r§8 -§rSorry, you guessed incorrectly. The correct number was ${correctNumber}. You lose ${betAmount} coins.`);
        player.runCommand(`playsound mob.wither.death @s`);
      }
    });
  }).catch(error => {
    console.error(error);
  });
}






let currentLevel = 1; // Initialize the level when starting
let maxLevels = 3;

function openDoor(player) {
  const form = new ModalFormData()
    .title("Open the Door")
    .textField(" \n              §l§cCA§eSI§aNO §bGA§dMES\n\n§r§eHow to Play:\n§rFirst, enter the bet amount (minimum 5k):\nthen guess which door is correct.\n\nEnter the bet amount (minimum 5k):\n§7* masukan jumlah taruhan (minimal 5k)", "5000");

  form.show(player).then(result => {
    const playerMoney = getScore("money", player.name);
    const betAmount = parseInt(result.formValues[0]);
    if (isNaN(betAmount) || betAmount < 5000 || betAmount > 500000) {
      player.sendMessage("§l§cCA§eSI§aNO §bGA§dMES §r§r§8 -§rPlease enter a minimum bet amount of 5k coins and a maximum of 500k.");
      return;
    }
    if (betAmount > playerMoney) {
      player.sendMessage("§l§cCA§eSI§aNO §bGA§dMES §r§8// §rSorry, you don't have enough money for this bet.");
      return;
    }
    // Start the game from level 1 with the specified bet amount
    playOpenDoorGame(player, betAmount);
  }).catch(error => {
    console.error(error);
  });
}

function playOpenDoorGame(player, betAmount) {
  const isZonk = Math.random() < 0.55;
  const isCorrectDoor = !isZonk && Math.random() < 0.45;

  const form = new ActionFormData()
    .title(`Choose a Door - Level ${currentLevel}`)
    .button(`§lDoor 1\n§r§oClick to open`, `textures/items/door_wood`)
    .button(`§lDoor 2\n§r§oClick to open`, `textures/items/door_wood`)
    .button(`§lDoor 3\n§r§oClick to open`, `textures/items/door_wood`)
    .button(`§lDoor 4\n§r§oClick to open`, `textures/items/door_wood`);

  form.show(player).then(result => {
    if (result.canceled) return player.sendMessage(`§l§cCA§eSI§aNO §bGA§dMES §r§r§8 -§rGame Canceled!`);
   
    if (isZonk && result.selection >= 0 && result.selection <= 3) {
      // Player chose the wrong door
      player.runCommandAsync(`summon lightning_bolt ~ ~120 ~`);
      player.runCommandAsync(`effect @s slowness 3 255 true`);
      player.runCommandAsync(`effect @s blindness 3 255 true`);
      player.runCommandAsync(`title @s title §l§cZONK`);
      player.runCommandAsync(`title @s subtitle §7Lol`);
      player.runCommand(`scoreboard players remove @s money ${betAmount}`);
      player.sendMessage(`§l§cCA§eSI§aNO §bGA§dMES §r§r§8 -§rYou chose the wrong door! You lose ${betAmount} coins.`);
      betAmount = 0;
      currentLevel = 1;
    } else if (isCorrectDoor && result.selection >= 0 && result.selection <= 3) {
      // Player successfully chose the correct door
      player.sendMessage(`§l§cCA§eSI§aNO §bGA§dMES §r§r§8 -§rYou chose the correct door! Congratulations! You've completed Level ${currentLevel}.`);
      // Add winnings to the player
      const winnings = betAmount * currentLevel;
      player.runCommand(`scoreboard players add @s money ${winnings}`);
      player.sendMessage(`§l§cCA§eSI§aNO §bGA§dMES §r§r§8 -§rCongratulations! You've completed all levels and won ${winnings} coins.`);
      // Reset currentLevel
      player.runCommandAsync(`summon fireworks_rocket ~ ~ ~1`);
      player.runCommandAsync(`summon fireworks_rocket ~1 ~ ~`);
      player.runCommandAsync(`summon fireworks_rocket ~ ~ ~-1`);
      player.runCommandAsync(`summon fireworks_rocket ~-1 ~ ~`);
      player.runCommandAsync(`playsound random.totem @s`);
      player.runCommandAsync(`title @s title §l§e!§f! §l§eJACKPOT §f!§e!`);
      player.runCommandAsync(`title @s subtitle §7Congratulations §e@s`);
      player.runCommandAsync(`summon lightning_bolt ~ ~120 ~`);
      player.runCommandAsync(`effect @s slowness 3 255 true`);
      player.runCommandAsync(`effect @s blindness 3 255 true`);
      betAmount = 0;
      currentLevel = 1;
    } else {
      // Player chose a different door
      const continueForm = new ActionFormData()
        .title("Continue")
        .body(` \n              §l§cCA§eSI§aNO §bGA§dMES\n\n§r§eInformation:\n\nYou've passed §clevel ${currentLevel} §fand successfully earned §d$${betAmount * currentLevel} §f.You can §econtinue §fthe game and increase the prize §fby clicking §aContinue §for you can stop and take §b$${betAmount * currentLevel} §fcoins`)
        .button(`§lContinue\n§r§oContinue`, `textures/ui/inventory_warning_xbox`)
        .button(`§lStop\n§r§oStop`, `textures/ui/icon_blackfriday`);
      continueForm.show(player).then(response => {
        if (response.selection === 0) {
          // Continue to the next level
          currentLevel++;
          playOpenDoorGame(player, betAmount);
        } else {
          // Take the money and stop
          player.runCommand(`scoreboard players add @s money ${betAmount * currentLevel}`);
          player.sendMessage(`§l§cCA§eSI§aNO §bGA§dMES §r§r§8 -§rYou've taken ${betAmount * currentLevel} coins and decided to stop playing. Thank you!`);
          // Reset currentLevel
          currentLevel = 1;
          betAmount = 0;
        }
      });
    }
  });
}





function openLuckyCardDraw(player) {
  const form = new ModalFormData()
    .title("Lucky Card Draw")
    .textField(" \n              §l§cCA§eSI§aNO §bGA§dMES\n\n§r§eHow to Play:\n\nFirst, §center §rthe betting amount, then the system will randomly §epick §fwhich card you have to find. If you §dsucceed §ryou will §eown §fthe bet\n\nEnter the bet amount (minimum 5k):\n§7* Masukan jumlah taruhan (minimal 5k)", "5000");

  const cardOptions = ["Ace", "King", "Queen", "Jack", "Ten"];

  form.show(player).then(result => {
    const playerMoney = getScore("money", player.name);
    const betAmount = parseInt(result.formValues[0]);

    if (isNaN(betAmount) || betAmount < 5000 || betAmount > 500000) {
      player.sendMessage("§l§cCA§eSI§aNO §bGA§dMES §r§r§8 -§rPlease enter a minimum bet amount of 5k coins and a maximum of 500k.");
      return;
    }

    if (betAmount > playerMoney) {
      player.sendMessage("§l§cCA§eSI§aNO §bGA§dMES §r§r§8 -§rSorry, you don't have enough money for this bet.");
      return;
    }

    // Randomly select the card to be found
    const correctCard = cardOptions[Math.floor(Math.random() * cardOptions.length)];

    const selectionForm = new ActionFormData()
      .title("Choose a Card")
      .body(`Find and select the card: §e${correctCard}`)
      .button("Card 1", `textures/ui/filledStar`)
      .button("Card 2", `textures/ui/filledStar`)
      .button("Card 3", `textures/ui/filledStar`)
      .button("Card 4", `textures/ui/filledStar`)
      .button("Card 5", `textures/ui/filledStar`);

    selectionForm.show(player).then(cardResult => {
      if (cardResult.selection === cardOptions.indexOf(correctCard)) {
        // Player chose the correct card
        player.runCommand(`playsound mob.wither.death @s`);
        player.runCommand(`scoreboard players add @s money ${betAmount}`);
        player.sendMessage(`§l§cCA§eSI§aNO §bGA§dMES §r§r§8 -§rCongratulations! You chose the correct card, which is ${correctCard}. You win ${betAmount} coins.`);
      } else {
        // Player chose the wrong card
        player.runCommand(`playsound mob.wither.death @s`);
        player.runCommand(`scoreboard players remove @s money ${betAmount}`);
        player.sendMessage(`§l§cCA§eSI§aNO §bGA§dMES §r§8 -§rSorry, you chose the wrong card. The correct card was ${correctCard}. You lose ${betAmount} coins.`);
      }
    });
  }).catch(error => {
    console.error(error);
  });
}
